"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorListener = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _antlr4Browser = _interopRequireDefault(require("@neo4j-cypher/antlr4-browser"));
class ErrorListener extends _antlr4Browser.default.error.ErrorListener {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "errors", []);
  }
  // eslint-disable-next-line no-unused-vars
  syntaxError(rec, sym, line, col, msg, e) {
    const {
      start,
      stop
    } = sym || {};
    if (msg === "mismatched input '<EOF>' expecting {';', SP}") {
      // suppress error about missing semicolon at the end of a query
      return;
    }
    if (msg === "missing ';' at '<EOF>'") {
      return;
    }
    if (msg === "mismatched input '<EOF>' expecting {':', CYPHER, EXPLAIN, PROFILE, USING, CREATE, DROP, LOAD, WITH, OPTIONAL, MATCH, UNWIND, MERGE, SET, DETACH, DELETE, REMOVE, FOREACH, RETURN, START, CALL}") {
      return;
    }
    this.errors.push({
      line,
      col,
      msg,
      start,
      stop
    });
  }
}
exports.ErrorListener = ErrorListener;