"use strict";

exports.__esModule = true;
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _swaggerUiEsBundleCore = _interopRequireDefault(require("./swagger-ui-es-bundle-core"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
class SwaggerUI extends _react.default.Component {
  constructor(props) {
    super(props);
    _defineProperty(this, "requestInterceptor", req => {
      if (typeof this.props.requestInterceptor === "function") {
        return this.props.requestInterceptor(req);
      }
      return req;
    });
    _defineProperty(this, "responseInterceptor", res => {
      if (typeof this.props.responseInterceptor === "function") {
        return this.props.responseInterceptor(res);
      }
      return res;
    });
    _defineProperty(this, "onComplete", () => {
      if (typeof this.props.onComplete === "function") {
        return this.props.onComplete(this.system);
      }
    });
    this.SwaggerUIComponent = null;
    this.system = null;
  }
  componentDidMount() {
    const ui = (0, _swaggerUiEsBundleCore.default)({
      plugins: this.props.plugins,
      spec: this.props.spec,
      url: this.props.url,
      layout: this.props.layout,
      defaultModelsExpandDepth: this.props.defaultModelsExpandDepth,
      defaultModelRendering: this.props.defaultModelRendering,
      presets: [_swaggerUiEsBundleCore.default.presets.apis, ...this.props.presets],
      requestInterceptor: this.requestInterceptor,
      responseInterceptor: this.responseInterceptor,
      onComplete: this.onComplete,
      docExpansion: this.props.docExpansion,
      supportedSubmitMethods: this.props.supportedSubmitMethods,
      queryConfigEnabled: this.props.queryConfigEnabled,
      defaultModelExpandDepth: this.props.defaultModelExpandDepth,
      displayOperationId: this.props.displayOperationId,
      tryItOutEnabled: this.props.tryItOutEnabled,
      displayRequestDuration: this.props.displayRequestDuration,
      requestSnippetsEnabled: this.props.requestSnippetsEnabled,
      requestSnippets: this.props.requestSnippets,
      showMutatedRequest: typeof this.props.showMutatedRequest === "boolean" ? this.props.showMutatedRequest : true,
      deepLinking: typeof this.props.deepLinking === "boolean" ? this.props.deepLinking : false,
      showExtensions: this.props.showExtensions,
      showCommonExtensions: this.props.showCommonExtensions,
      filter: ["boolean", "string"].includes(typeof this.props.filter) ? this.props.filter : false,
      persistAuthorization: this.props.persistAuthorization,
      withCredentials: this.props.withCredentials,
      oauth2RedirectUrl: this.props.oauth2RedirectUrl
    });
    this.system = ui;
    this.SwaggerUIComponent = ui.getComponent("App", "root");
    this.forceUpdate();
  }
  render() {
    return this.SwaggerUIComponent ? /*#__PURE__*/_react.default.createElement(this.SwaggerUIComponent, null) : null;
  }
  componentDidUpdate(prevProps) {
    const prevStateUrl = this.system.specSelectors.url();
    if (this.props.url !== prevStateUrl || this.props.url !== prevProps.url) {
      // flush current content
      this.system.specActions.updateSpec("");
      if (this.props.url) {
        // update the internal URL
        this.system.specActions.updateUrl(this.props.url);
        // trigger remote definition fetch
        this.system.specActions.download(this.props.url);
      }
    }
    const prevStateSpec = this.system.specSelectors.specStr();
    if (this.props.spec && (this.props.spec !== prevStateSpec || this.props.spec !== prevProps.spec)) {
      if (typeof this.props.spec === "object") {
        this.system.specActions.updateSpec(JSON.stringify(this.props.spec));
      } else {
        this.system.specActions.updateSpec(this.props.spec);
      }
    }
  }
}
exports.default = SwaggerUI;
SwaggerUI.propTypes = {
  spec: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.object]),
  url: _propTypes.default.string,
  layout: _propTypes.default.string,
  requestInterceptor: _propTypes.default.func,
  responseInterceptor: _propTypes.default.func,
  onComplete: _propTypes.default.func,
  docExpansion: _propTypes.default.oneOf(["list", "full", "none"]),
  supportedSubmitMethods: _propTypes.default.arrayOf(_propTypes.default.oneOf(["get", "put", "post", "delete", "options", "head", "patch", "trace"])),
  queryConfigEnabled: _propTypes.default.bool,
  plugins: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.object), _propTypes.default.arrayOf(_propTypes.default.func), _propTypes.default.func]),
  displayOperationId: _propTypes.default.bool,
  showMutatedRequest: _propTypes.default.bool,
  defaultModelExpandDepth: _propTypes.default.number,
  defaultModelsExpandDepth: _propTypes.default.number,
  defaultModelRendering: _propTypes.default.oneOf(["example", "model"]),
  presets: _propTypes.default.arrayOf(_propTypes.default.func),
  deepLinking: _propTypes.default.bool,
  showExtensions: _propTypes.default.bool,
  showCommonExtensions: _propTypes.default.bool,
  filter: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
  requestSnippetsEnabled: _propTypes.default.bool,
  requestSnippets: _propTypes.default.object,
  tryItOutEnabled: _propTypes.default.bool,
  displayRequestDuration: _propTypes.default.bool,
  persistAuthorization: _propTypes.default.bool,
  withCredentials: _propTypes.default.bool,
  oauth2RedirectUrl: _propTypes.default.string
};
SwaggerUI.defaultProps = {
  layout: "BaseLayout",
  supportedSubmitMethods: ["get", "put", "post", "delete", "options", "head", "patch", "trace"],
  queryConfigEnabled: false,
  docExpansion: "list",
  defaultModelsExpandDepth: 1,
  defaultModelRendering: "example",
  presets: [],
  deepLinking: false,
  displayRequestDuration: false,
  showExtensions: false,
  showCommonExtensions: false,
  filter: false,
  requestSnippetsEnabled: false,
  requestSnippets: {
    generators: {
      "curl_bash": {
        title: "cURL (bash)",
        syntax: "bash"
      },
      "curl_powershell": {
        title: "cURL (PowerShell)",
        syntax: "powershell"
      },
      "curl_cmd": {
        title: "cURL (CMD)",
        syntax: "bash"
      }
    },
    defaultExpanded: true,
    languages: null // e.g. only show curl bash = ["curl_bash"]
  },

  persistAuthorization: false
};
SwaggerUI.presets = _swaggerUiEsBundleCore.default.presets;
SwaggerUI.plugins = _swaggerUiEsBundleCore.default.plugins;

