// -*- C++ -*-

//=============================================================================
/**
 * @file Num_Threads_Monitor.h
 *
 * @author Jeff Parsons <j.parsons@vanderbilt.edu>
 */
//=============================================================================

#ifndef NUM_THREADS_MONITOR_H
#define NUM_THREADS_MONITOR_H

#include /**/ "ace/pre.h"

#include "ace/Monitor_Base.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#if defined (ACE_HAS_MONITOR_FRAMEWORK) && (ACE_HAS_MONITOR_FRAMEWORK == 1)

#if defined (ACE_HAS_PDH_H) && !defined (ACE_LACKS_PDH_H)
#include "ace/Monitor_Control/Windows_Monitor.h"
#endif

#include "ace/Monitor_Control/Monitor_Control_export.h"

ACE_BEGIN_VERSIONED_NAMESPACE_DECL

namespace ACE
{
  namespace Monitor_Control
  {
    /**
     * @class Num_Threads_Monitor
     *
     * @brief Monitor total number of threads in the system.
     */
    class MONITOR_CONTROL_Export Num_Threads_Monitor
      : public Monitor_Base
#if defined (ACE_HAS_WIN32_PDH)
      , public Windows_Monitor
#endif
    {
    public:
      Num_Threads_Monitor (const char* name);

      /// Implementation of the pure virtual method.
      virtual void update ();

      /// Stores the default name, used if none is supplied by the user.
      static const char* default_name ();

    private:
      /// Overridden reset, calls platform-specific reset.
      virtual void clear_i ();

    private:
      static const char* default_name_;

#if defined (ACE_LINUX)
      FILE *file_ptr_;
      char buf_[1024];
      unsigned long nthreads_;
#endif
    };
  }
}

ACE_END_VERSIONED_NAMESPACE_DECL

#endif /* ACE_HAS_MONITOR_FRAMEWORK==1 */

#include /**/ "ace/post.h"

#endif // NUM_THREADS_MONITOR_H
