#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dracula: The Resurrection
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241218.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='dracula-1-the-resurrection'
GAME_NAME='Dracula: The Resurrection'

ARCHIVE_BASE_EN_0_NAME='setup_dracula_the_resurrection_2.1.0.5.exe'
ARCHIVE_BASE_EN_0_MD5='4f3ac9ea7b645ec3bc0ec2c9de24be79'
ARCHIVE_BASE_EN_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_EN_0_EXTRACTOR_OPTIONS='--gog'
ARCHIVE_BASE_EN_0_PART1_NAME='setup_dracula_the_resurrection_2.1.0.5.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='284f93ed3799267604cc1f25a2329699'
ARCHIVE_BASE_EN_0_PART1_TYPE='rar'
ARCHIVE_BASE_EN_0_SIZE='1336964'
ARCHIVE_BASE_EN_0_VERSION='1.0-gog2.1.0.5'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/dracula_trilogy'

ARCHIVE_BASE_FR_0_NAME='setup_dracula_the_resurrection_french_2.1.0.5.exe'
ARCHIVE_BASE_FR_0_MD5='4665678362c34ccf2f19252d7f66d6d7'
ARCHIVE_BASE_FR_0_EXTRACTOR='innoextract'
ARCHIVE_BASE_FR_0_EXTRACTOR_OPTIONS='--gog'
ARCHIVE_BASE_FR_0_PART1_NAME='setup_dracula_the_resurrection_french_2.1.0.5-1.bin'
ARCHIVE_BASE_FR_0_PART1_MD5='6021c178c8bb2aa291ec4fc839263d19'
ARCHIVE_BASE_FR_0_PART1_TYPE='rar'
ARCHIVE_BASE_FR_0_SIZE='1480558'
ARCHIVE_BASE_FR_0_VERSION='1.0-gog2.1.0.5'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/dracula_trilogy'

CONTENT_PATH_DEFAULT='game'
CONTENT_GAME_BIN_FILES='
dct.dll
dhook.dll
dra32lib.dll
fnx_vr.dll
smackw32.dll
dracula.exe'
CONTENT_GAME_L10N_FILES='
a08aanim01.4xm
a08aanim02.4xm
a08aanim03.4xm
a08aanim04.4xm
a08aanim05.4xm
b04anim.4xm
b10banim.4xm
e02banim02.4xm
e02banim03.4xm
m1barinadiag01.4xm
m1barinadiag02.4xm
m1barinadiag03.4xm
m1barinadiag04.4xm
m1barinadiag05.4xm
m1barinadiag06.4xm
m1barinadiag07.4xm
m1barinadiag08.4xm
m1michadiag02.4xm
m1michadiag04.4xm
m1michadiag05.4xm
m1michadiag06.4xm
m1michadiag08.4xm
m2dorkodiag01.4xm
m2dorkodiag02.4xm
m2dorkodiag03.4xm
m2dorkodiag04.4xm
m2dorkodiag05.4xm
m2dorkodiag06.4xm
m2dorkodiag07.4xm
m2e02aanim.4xm
m2h03pfaanim.4xm
m2i06anim.4xm
prologue1.4xm
prologue2.4xm
prologue3.4xm
trans02.4xm
barinapf.tst
michapf.tst
interface.tst
dorkopf.tst
h01afv.tst
h42apfa.tst
h42apfb.tst
h42bpfa.tst
h42bpfb.tst
insertcd2.tst
quitte.vr
logo.vr
interface.vr
debut.vr
michapf.vr
dorkopf.vr
barinapf.vr
credit.vr
nouvellepartie.vr
a09a.vr
insertcd.vr
i03a.vr
m2b09a.vr
m2g05pfc.vr
m2lutrinpf.vr
dorko.wav'
CONTENT_GAME_DATA_FILES='
a18tst
compiler.dat
cursor1.gif
cursor2.gif
retour.gif
signal.gif
dracula.ico
*.4xm
*.lst
*.pcx
*.tst
*.vr
*.wav'
CONTENT_DOC_DATA_FILES='
*.pdf'

USER_PERSISTENT_FILES='
Saved_?.bin'

WINE_VIRTUAL_DESKTOP='auto'
## Set Windows version to Windows 98, otherwise the menu can not be opened in-game
WINE_WINETRICKS_VERBS='win98'

APP_MAIN_EXE='dracula.exe'
APP_MAIN_ICON='dracula.ico'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Convert all file paths to lowercase
	tolower .
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
